/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import com.headius.invokebinder.Binder;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MutableCallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import org.jruby.MetaClass;
import org.jruby.Ruby;
import org.jruby.RubyBinding;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyModule;
import org.jruby.RubyProc;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.runtime.Block;
import org.jruby.runtime.EventHook;
import org.jruby.runtime.RubyEvent;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class TraceEventManager {
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    public static final MethodHandle TRACE_ON = Binder.from(Void.TYPE, ThreadContext.class, IRubyObject.class, RubyEvent.class, String.class, String.class, Integer.TYPE).invokeStaticQuiet(LOOKUP, IRRuntimeHelpers.class, "callTrace");
    public static final MethodHandle TRACE_OFF = Binder.from(Void.TYPE, ThreadContext.class, IRubyObject.class, RubyEvent.class, String.class, String.class, Integer.TYPE).drop(1, 5).identity();
    public static final MethodHandle B_TRACE_ON = Binder.from(Void.TYPE, ThreadContext.class, Block.class, RubyEvent.class, String.class, String.class, Integer.TYPE).invokeStaticQuiet(LOOKUP, IRRuntimeHelpers.class, "callTrace");
    public static final MethodHandle B_TRACE_OFF = Binder.from(Void.TYPE, ThreadContext.class, Block.class, RubyEvent.class, String.class, String.class, Integer.TYPE).drop(1, 5).identity();
    private static final EventHook[] EMPTY_HOOKS = new EventHook[0];
    private final Ruby runtime;
    private volatile EventHook[] eventHooks = EMPTY_HOOKS;
    private boolean hasEventHooks;
    private final CallTraceFuncHook callTraceFuncHook = new CallTraceFuncHook(null);
    private final MutableCallSite callTrace = new MutableCallSite(TRACE_OFF);
    private final MutableCallSite bcallTrace = new MutableCallSite(B_TRACE_OFF);
    private static final EnumSet<RubyEvent> interest = EnumSet.of(RubyEvent.C_CALL, new RubyEvent[]{RubyEvent.C_RETURN, RubyEvent.CALL, RubyEvent.CLASS, RubyEvent.END, RubyEvent.LINE, RubyEvent.RAISE, RubyEvent.RETURN});

    public TraceEventManager(Ruby runtime2) {
        this.runtime = runtime2;
    }

    public synchronized void addEventHook(EventHook hook) {
        if (!RubyInstanceConfig.FULL_TRACE_ENABLED && hook.needsDebug()) {
            this.runtime.getWarnings().warn("tracing (e.g. set_trace_func) will not capture all events without --debug flag");
        }
        EventHook[] hooks = this.eventHooks;
        EventHook[] newHooks = Arrays.copyOf(hooks, hooks.length + 1);
        newHooks[hooks.length] = hook;
        this.eventHooks = newHooks;
        this.hasEventHooks = true;
        this.enableTraceSites(hook);
    }

    public synchronized void removeEventHook(EventHook hook) {
        EventHook[] hooks = this.eventHooks;
        if (hooks.length == 0) {
            return;
        }
        int pivot = -1;
        for (int i2 = 0; i2 < hooks.length; ++i2) {
            if (!hooks[i2].equals(hook)) continue;
            pivot = i2;
            break;
        }
        if (pivot == -1) {
            return;
        }
        EventHook[] newHooks = new EventHook[hooks.length - 1];
        if (pivot != 0) {
            System.arraycopy(hooks, 0, newHooks, 0, pivot);
        }
        if (pivot != hooks.length - 1) {
            System.arraycopy(hooks, pivot + 1, newHooks, pivot, hooks.length - (pivot + 1));
        }
        this.eventHooks = newHooks;
        if (newHooks.length == 0) {
            this.hasEventHooks = false;
            this.disableTraceSites(hook);
        }
    }

    private void enableTraceSites(EventHook hook) {
        if (hook.isInterestedInEvent(RubyEvent.CALL) || hook.isInterestedInEvent(RubyEvent.RETURN)) {
            this.callTrace.setTarget(TRACE_ON);
        }
        if (hook.isInterestedInEvent(RubyEvent.B_CALL) || hook.isInterestedInEvent(RubyEvent.B_RETURN)) {
            this.bcallTrace.setTarget(B_TRACE_ON);
        }
    }

    private void disableTraceSites(EventHook hook) {
        if (hook.isInterestedInEvent(RubyEvent.CALL) || hook.isInterestedInEvent(RubyEvent.RETURN)) {
            this.callTrace.setTarget(TRACE_OFF);
        }
        if (hook.isInterestedInEvent(RubyEvent.B_CALL) || hook.isInterestedInEvent(RubyEvent.B_RETURN)) {
            this.bcallTrace.setTarget(B_TRACE_OFF);
        }
    }

    private void disableTraceSites() {
        this.callTrace.setTarget(TRACE_OFF);
        this.bcallTrace.setTarget(B_TRACE_OFF);
    }

    public void setTraceFunction(RubyProc traceFunction) {
        this.setTraceFunction(this.callTraceFuncHook, traceFunction);
    }

    public void setTraceFunction(CallTraceFuncHook hook, RubyProc traceFunction) {
        this.removeEventHook(hook);
        if (traceFunction == null) {
            return;
        }
        hook.setTraceFunc(traceFunction);
        this.addEventHook(hook);
    }

    public void removeAllCallEventHooksFor(ThreadContext context) {
        if (this.eventHooks.length == 0) {
            return;
        }
        List<EventHook> hooks = new ArrayList<EventHook>(Arrays.asList(this.eventHooks));
        hooks = hooks.stream().filter(hook -> !(hook instanceof CallTraceFuncHook) || !((CallTraceFuncHook)hook).getThread().equals(context)).collect(Collectors.toList());
        EventHook[] newHooks = new EventHook[hooks.size()];
        this.eventHooks = hooks.toArray(newHooks);
        if (hooks.size() == 0) {
            this.hasEventHooks = false;
            this.disableTraceSites();
        }
    }

    public void callEventHooks(ThreadContext context, RubyEvent event2, String file2, int line, String name2, IRubyObject type2) {
        if (context.isEventHooksEnabled()) {
            EventHook[] hooks;
            for (EventHook eventHook : hooks = this.eventHooks) {
                if (!eventHook.isInterestedInEvent(event2)) continue;
                IRubyObject klass = context.nil;
                if (type2 instanceof RubyModule) {
                    if (((RubyModule)type2).isIncluded()) {
                        klass = ((RubyModule)type2).getOrigin();
                    } else if (((RubyModule)type2).isSingleton()) {
                        klass = ((MetaClass)type2).getAttached();
                    }
                }
                eventHook.event(context, event2, file2, line, name2, klass);
            }
        }
    }

    public MutableCallSite getCallReturnSite() {
        return this.callTrace;
    }

    public MutableCallSite getBCallBReturnSite() {
        return this.bcallTrace;
    }

    public boolean hasEventHooks() {
        return this.hasEventHooks;
    }

    public static class CallTraceFuncHook
    extends EventHook {
        private RubyProc traceFunc;
        private final ThreadContext thread;

        public CallTraceFuncHook(ThreadContext context) {
            this.thread = context;
        }

        public void setTraceFunc(RubyProc traceFunc) {
            this.traceFunc = traceFunc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void eventHandler(ThreadContext context, String eventName, String file2, int line, String name2, IRubyObject type2) {
            if (context.isWithinTrace()) {
                return;
            }
            if (this.thread != null && this.thread != context) {
                return;
            }
            if (file2 == null) {
                file2 = "(ruby)";
            }
            if (type2 == null) {
                type2 = context.nil;
            }
            Ruby runtime2 = context.runtime;
            RubyBinding binding2 = RubyBinding.newBinding(runtime2, context.currentBinding());
            switch (eventName) {
                case "c_return": {
                    eventName = "c-return";
                    break;
                }
                case "c_call": {
                    eventName = "c-call";
                }
            }
            context.preTrace();
            try {
                this.traceFunc.call(context, runtime2.newString(eventName), runtime2.newString(file2), runtime2.newFixnum(line), name2 != null ? runtime2.newSymbol(name2) : runtime2.getNil(), binding2, type2);
            }
            finally {
                context.postTrace();
            }
        }

        public boolean equals(Object other) {
            if (!(other instanceof CallTraceFuncHook)) {
                return false;
            }
            return this.traceFunc == ((CallTraceFuncHook)other).traceFunc && this.thread == ((CallTraceFuncHook)other).thread;
        }

        public int hashCode() {
            return 13 * this.traceFunc.hashCode() + 5 * (this.thread == null ? 0 : this.thread.hashCode());
        }

        @Override
        public boolean isInterestedInEvent(RubyEvent event2) {
            return interest.contains((Object)event2);
        }

        public ThreadContext getThread() {
            return this.thread;
        }

        public EnumSet<RubyEvent> eventSet() {
            return interest;
        }
    }
}

